
#ifndef SONNETCORE_EXPORT_H
#define SONNETCORE_EXPORT_H

#ifdef SONNETCORE_STATIC_DEFINE
#  define SONNETCORE_EXPORT
#  define SONNETCORE_NO_EXPORT
#else
#  ifndef SONNETCORE_EXPORT
#    ifdef KF5SonnetCore_EXPORTS
        /* We are building this library */
#      define SONNETCORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define SONNETCORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef SONNETCORE_NO_EXPORT
#    define SONNETCORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef SONNETCORE_DECL_DEPRECATED
#  define SONNETCORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef SONNETCORE_DECL_DEPRECATED_EXPORT
#  define SONNETCORE_DECL_DEPRECATED_EXPORT SONNETCORE_EXPORT SONNETCORE_DECL_DEPRECATED
#endif

#ifndef SONNETCORE_DECL_DEPRECATED_NO_EXPORT
#  define SONNETCORE_DECL_DEPRECATED_NO_EXPORT SONNETCORE_NO_EXPORT SONNETCORE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef SONNETCORE_NO_DEPRECATED
#    define SONNETCORE_NO_DEPRECATED
#  endif
#endif

#define SONNETCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(SONNETCORE_NO_DEPRECATED) && !defined(SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define SONNETCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(SONNETCORE_NO_DEPRECATED_WARNINGS) && !defined(SONNETCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define SONNETCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define SONNETCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(SONNETCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define SONNETCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(SONNETCORE_NO_DEPRECATED)
#  undef SONNETCORE_DEPRECATED
#  define SONNETCORE_DEPRECATED_EXPORT SONNETCORE_EXPORT
#  define SONNETCORE_DEPRECATED_NO_EXPORT SONNETCORE_NO_EXPORT
#elif defined(SONNETCORE_NO_DEPRECATED_WARNINGS)
#  define SONNETCORE_DEPRECATED
#  define SONNETCORE_DEPRECATED_EXPORT SONNETCORE_EXPORT
#  define SONNETCORE_DEPRECATED_NO_EXPORT SONNETCORE_NO_EXPORT
#else
#  define SONNETCORE_DEPRECATED SONNETCORE_DECL_DEPRECATED
#  define SONNETCORE_DEPRECATED_EXPORT SONNETCORE_DECL_DEPRECATED_EXPORT
#  define SONNETCORE_DEPRECATED_NO_EXPORT SONNETCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define SONNETCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define SONNETCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef SONNETCORE_NO_DEPRECATED
#  define SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55900
#endif
#ifdef SONNETCORE_NO_DEPRECATED_WARNINGS
#  define SONNETCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef SONNETCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define SONNETCORE_DEPRECATED_WARNINGS_SINCE SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define SONNETCORE_DEPRECATED_WARNINGS_SINCE 0x55900
#  endif
#endif

#ifndef SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef SONNETCORE_DEPRECATED
#  define SONNETCORE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define SONNETCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* SONNETCORE_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_SONNETCORE_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_SONNETCORE_EXPORT_H


#define SONNETCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(SONNETCORE_NO_DEPRECATED) && !defined(SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define SONNETCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(SONNETCORE_NO_DEPRECATED_WARNINGS) && !defined(SONNETCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define SONNETCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define SONNETCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(SONNETCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define SONNETCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(SONNETCORE_NO_DEPRECATED)
#  undef SONNETCORE_DEPRECATED
#  define SONNETCORE_DEPRECATED_EXPORT SONNETCORE_EXPORT
#  define SONNETCORE_DEPRECATED_NO_EXPORT SONNETCORE_NO_EXPORT
#elif defined(SONNETCORE_NO_DEPRECATED_WARNINGS)
#  define SONNETCORE_DEPRECATED
#  define SONNETCORE_DEPRECATED_EXPORT SONNETCORE_EXPORT
#  define SONNETCORE_DEPRECATED_NO_EXPORT SONNETCORE_NO_EXPORT
#else
#  define SONNETCORE_DEPRECATED SONNETCORE_DECL_DEPRECATED
#  define SONNETCORE_DEPRECATED_EXPORT SONNETCORE_DECL_DEPRECATED_EXPORT
#  define SONNETCORE_DEPRECATED_NO_EXPORT SONNETCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define SONNETCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define SONNETCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef SONNETCORE_NO_DEPRECATED
#  define SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55900
#endif
#ifdef SONNETCORE_NO_DEPRECATED_WARNINGS
#  define SONNETCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef SONNETCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define SONNETCORE_DEPRECATED_WARNINGS_SINCE SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define SONNETCORE_DEPRECATED_WARNINGS_SINCE 0x55900
#  endif
#endif

#ifndef SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef SONNETCORE_DEPRECATED
#  define SONNETCORE_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > SONNETCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define SONNETCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif


#endif /* ECM_GENERATEEXPORTHEADER_SONNETCORE_EXPORT_H */
